#include <STC15F2K60S2.H>
#include <74hc138.h>
#include <Nixie.h>
#include <Key.h>
#include <ultrasound.h>
#include <stdio.h>

unsigned int fcount, dat;
unsigned int length;
bit flag, flag_u;
unsigned int Rec[10]={0,0,0,0,0,0,0,0,0,0};
unsigned char rec_dex;

void InitTimer()
{
	TH0=0xff;
	TL0=0xff;// 计数器模式
	
	TH1=(65535-1000)/256;
	TL1=(65535-1000)%256;// 1ms定时器
	
	TMOD=0x16;// 设定模式：定时器0为计数 定时器1为定时
	ET0=1;
	ET1=1; // 打开定时器开关
	EA=1; // 打开总开关
	
	TR0=1;
	TR1=1; // 开始工作
}

void LED(unsigned char addr,enabel)
{
	static unsigned char temp=0x00, temp_old=0xff;
	if(enabel)
		temp|=0x01<<addr;
	else
		temp&=~(0x01<<addr);
	if(temp!=temp_old)
	{
		P0=~temp;
		InitHC138(4);
		temp_old = temp;
	}
}
void Uart_Loop()
{
	if(rec_dex>0)
	{
		if(rec_dex==4)
		{
			if(Rec[0]=='L'&&Rec[1]=='E'&&Rec[2]=='D')
			{
				LED(Rec[3]-'0',1);
				printf("OK\r\n");
			}
			else printf("ERROR\r\n");
		}
		else
			printf("ERROR\r\n");
		rec_dex=0;
	}
}

void main()
{
	InitTimer();
	Uart1_Init();
	while(1)
	{
		//		Nixie_SetBuf(1,dat/10000);// NE555频率显示
//		Nixie_SetBuf(2,(dat/1000)%10);
//		Nixie_SetBuf(3,(dat/100)%10);
//		Nixie_SetBuf(4,(dat/10)%10);
//		Nixie_SetBuf(5,dat%10);
		if(flag)
		{
			flag=0;
			length=csb();
		}
		if(flag_u)
		{
			flag_u=0;
			Uart_Loop();
		}
		
		Nixie_SetBuf(1,length/100);// 超声波
		Nixie_SetBuf(2,(length/10)%10);
		Nixie_SetBuf(3,length%10);
		
	}
}

void SeverTime0() interrupt 1
{
	fcount++;
}

void SeverTime1() interrupt 3
{
	static unsigned int count0;
	static unsigned char count1, count2;
	TH1=(65535-1000)/256;
	TL1=(65535-1000)%256; // 不自动重装载，设定初值
	
	count0++;
	if(count0>=1000)
	{
		dat=fcount;
		fcount=0;
		count0=0;
	}
	count1++;
	if(count1>=2)
	{
		Nixie_Loop();
		count1=0;
	}
	count2++;
	if(count2>=200)
	{
		flag=1;
		flag_u=1;
		count2=0;
	}
}

void Uart1_Isr(void) interrupt 4
{

	if (RI)				//检测串口1接收中断
	{
		Rec[rec_dex]=SBUF;
		rec_dex++;
		RI = 0;			//清除串口1接收中断请求位
	}
}
